#include "sm.h"
#include "switches.h"
#include <windows.h>

char*  CodeSecNames[] = { ".text", "AUTO", "CODE" };
DWORD  CodeSecNamesCount = sizeof(CodeSecNames)/sizeof(CodeSecNames[0]);

char*  DataSecNames[] = { ".data", "DATA", "DGROUP" };
DWORD  DataSecNames = sizeof(DataSecNames)/sizeof(DataSecNames[0]);

char*  BssSecNames[] = { ".bss", "BSS" };
DWORD  BssSecNamesCount = sizeof(BssSecNames)/sizeof(BssSecNames[0]);

char*  IdataSecNames[] = { ".idata" };
DWORD  IdataSecNamesCount = sizeof(IdataSecNames)/sizeof(IdataSecNames[0]);

char*  RdataSecNames[] = { ".rdata" };
DWORD  RdataSecNamesCount = sizeof(RdataSecNames)/sizeof(RdataSecNames[0]);

char*  RelocSecNames[] = { ".reloc" };
DWORD  RelocSecNamesCount = sizeof(RelocSecNames)/sizeof(RelocSecNames[0]);

char*  RsrcSecNames[] = { ".rsrc" };
DWORD  RsrcSecNamesCount = sizeof(RsrcSecNames)/sizeof(RsrcSecNames[0]);


// some kernel32 functions

static char* Kernel32Func[] = {"AllocConsole","Beep","BuildCommDCBA",
     "BuildCommDCBAndTimeoutsA","CallNamedPipeA","ClearCommBreak","ClearCommError",
     "CloseHandle","ConnectNamedPipe","CopyFileA","CreateConsoleScreenBuffer",
     "CreateDirectoryA","CreateEventA","CreateFileA","CreateFileMappingA",
     "CreateMutexA","CreateNamedPipeA","CreatePipe","CreateProcessA","CreateSemaphoreA",
     "CreateThread","DeleteAtom","DeleteCriticalSection","DeleteFileA","DeviceIoControl",
     "DisconnectNamedPipe","DosDateTimeToFileTime","DuplicateHandle","EnterCriticalSection",
     "ExitProcess","ExitThread","FileTimeToDosDateTime","FileTimeToLocalFileTime",
     "FileTimeToSystemTime","FindClose","FindFirstFileA","FindNextFileA","FindResourceA",
     "FindResourceExA","FreeConsole","FreeLibrary","FreeResource","GetACP",
     "GetCPInfo","GetCommConfig","GetCommMask","GetCommState","GetCommTimeouts",
     "GetCommandLineA","GetConsoleCP","GetConsoleMode","GetConsoleOutputCP","GetConsoleTitleA",
     "GetCurrencyFormatA","GetCurrentDirectoryA","GetCurrentProcess","GetCurrentProcessId",
     "GetCurrentThread","GetCurrentThreadId","GetDateFormatA","GetDiskFreeSpaceA",
     "GetDriveTypeA","GetEnvironmentStringsA","GetEnvironmentVariableA",
     "GetExitCodeProcess","GetExitCodeThread","GetFileAttributesA","GetFileSize",
     "GetFileTime","GetFileType","GetFullPathNameA","GetLastError","GetLocalTime",
     "GetLocaleInfoA","GetLogicalDriveStringsA","GetLogicalDrives","GetModuleFileNameA",
     "GetModuleHandleA","GetNamedPipeInfo","GetPriorityClass","GetProcAddress",
     "GetStdHandle","GetSystemDirectoryA","GetSystemInfo","GetSystemTime","GetTempPathA",
     "GetThreadPriority","GetTickCount","GetVersionExA","GetWindowsDirectoryA",
     "GlobalAlloc","GlobalFree","GlobalHandle","GlobalLock","GlobalReAlloc","GlobalSize",
     "GlobalUnlock","InitializeCriticalSection","InterlockedDecrement","InterlockedExchange",
     "InterlockedIncrement","LeaveCriticalSection","LoadLibraryA","LoadModule",
     "LoadResource","LocalFileTimeToFileTime","LockFile","MapViewOfFile","MoveFileA",
     "OpenEventA","OpenFileMappingA","OpenMutexA","OpenProcess","OpenSemaphoreA",
     "PeekConsoleInputA","PurgeComm","ReadConsoleA","ReadConsoleInputA","ReadConsoleOutputA",
     "ReadFile","ReleaseMutex","ReleaseSemaphore","RemoveDirectoryA","ResetEvent",
     "ResumeThread","SetCommMask","SetCommState","SetCommTimeouts","SetConsoleCP",
     "SetConsoleCtrlHandler","SetConsoleCursorPosition","SetConsoleMode","SetConsoleOutputCP",
     "SetConsoleScreenBufferSize","SetConsoleTextAttribute","SetConsoleTitleA",
     "SetCurrentDirectoryA","SetEndOfFile","SetEvent","SetFileAttributesA","SetFilePointer",
     "SetFileTime","SetLocalTime","SetPriorityClass","SetStdHandle","SetThreadPriority",
     "SetupComm","SizeofResource","Sleep","SuspendThread","SystemTimeToFileTime",
     "TerminateProcess","TerminateThread","TlsAlloc","TlsFree","TlsGetValue","TlsSetValue",
     "UnlockFile","UnmapViewOfFile","WaitCommEvent","WaitForMultipleObjects",
     "WaitForSingleObject","WriteConsoleA","WriteConsoleInputA","WriteConsoleOutputA",
     "WriteFile","lstrcmpA", "LocalAlloc", "LocalReAlloc", "LocalFree", "VirtualProtectEx",
     "lstrcmpi" };

#define KERNEL32_FUNC_COUNT  (sizeof(Kernel32Func)/sizeof(Kernel32Func[0]))


// some user32 functions

static char* User32Func[] = {"AdjustWindowRect","AppendMenuA","AttachThreadInput",
     "BeginPaint","CallMsgFilterA","CascadeChildWindows","CascadeWindows","ChangeMenuA",
     "CharLowerA","CharToOemA","CharToOemBuffA","CharUpperA","CharUpperBuffA",
     "CheckDlgButton","CheckMenuItem","CheckRadioButton","ChildWindowFromPoint",
     "ClientToScreen","CloseWindow","CopyRect","CreateCursor","CreateIcon","CreateMenu",
     "CreatePopupMenu","CreateWindowExA","DefDlgProcA","DefWindowProcA","DeleteMenu",
     "DestroyCursor","DestroyIcon","DestroyMenu","DestroyWindow","DispatchMessageA",
     "EnableMenuItem","EnableWindow","EndDialog","EndPaint","EnumChildWindows",
     "EnumDesktopWindows","EnumThreadWindows","EnumWindows","ExitWindowsEx","FillRect",
     "FindWindowA","FrameRect","GetActiveWindow","GetClassLongA","GetClientRect",
     "GetCursorPos","GetDC","GetDesktopWindow","GetDlgItem","GetFocus","GetForegroundWindow",
     "GetKeyboardLayout","GetKeyboardState","GetMenu","GetMenuDefaultItem","GetMenuItemCount",
     "GetMenuItemID","GetMenuItemRect","GetMenuState","GetMenuStringA","GetMessageA",
     "GetParent","GetSysColor","GetSystemMenu","GetSystemMetrics","GetTopWindow",
     "GetWindow","GetWindowDC","GetWindowLongA","GetWindowPlacement","GetWindowRect",
     "GetWindowTextA","GetWindowThreadProcessId","InsertMenuA","InsertMenuItemA",
     "InvalidateRect","IsChild","IsDialogMessageA","IsWindow","IsWindowEnabled",
     "IsWindowVisible","IsZoomed","KillTimer","LoadCursorA","LoadIconA","LoadMenuA",
     "LoadStringA","MessageBoxA","ModifyMenuA","MoveWindow","PeekMessageA","PostMessageA",
     "PostQuitMessage","PtInRect","RegisterClassA","RegisterClassExA","ReleaseDC",
     "RemoveMenu","ScreenToClient","ScrollWindow","ScrollWindowEx","SendMessageA",
     "SetActiveWindow","SetClassLongA","SetCursor","SetCursorPos","SetFocus","SetForegroundWindow",
     "SetMenu","SetParent","SetRect","SetScrollInfo","SetScrollPos","SetScrollRange",
     "SetTimer","SetWindowPlacement","SetWindowPos","SetWindowTextA","ShowCursor",
     "ShowOwnedPopups","ShowWindow","TrackPopupMenu","TranslateAcceleratorA","TranslateMessage",
     "UnregisterClassA","UpdateWindow","WaitForInputIdle","WindowFromDC","WindowFromPoint",
     "wsprintfA" };

#define USER32_FUNC_COUNT (sizeof(User32Func)/sizeof(User32Func[0]))


// some gdi32 functions

static char* Gdi32Func[] = { "AnimatePalette","Arc","ArcTo","BeginPath","BitBlt",
     "CreateBitmap","CreateDCA","CreateDIBitmap","CreateFontA","CreatePalette",
     "CreatePen","CreateRectRgn","CreateSolidBrush","DeleteDC","DeleteObject",
     "Ellipse","EnumFontsA","EnumObjects","FillPath","FillRgn","FloodFill","FrameRgn",
     "GetArcDirection","GetBitmapBits","GetBkColor","GetBkMode","GetBoundsRect",
     "GetCharABCWidthsA","GetCharWidth32A","GetDIBits","GetDeviceCaps","GetKerningPairsA",
     "GetMapMode","GetNearestColor","GetObjectA","GetPath","GetPixel","GetPixelFormat",
     "GetRgnBox","GetStockObject","GetSystemPaletteEntries","GetSystemPaletteUse",
     "GetTextAlign","GetTextColor","GetTextMetricsA","GetViewportExtEx","GetViewportOrgEx",
     "GetWindowExtEx","GetWindowOrgEx","GetWorldTransform","LineTo","MoveToEx","PaintRgn",
     "PolyDraw","PtInRegion","RealizePalette","RectVisible","Rectangle","ResizePalette",
     "RestoreDC","SaveDC","SelectObject","SelectPalette","SetBitmapBits","SetBkColor",
     "SetBkMode","SetDIBits","SetDIBitsToDevice","SetMapMode","SetPixel","SetPixelFormat",
     "SetTextAlign","SetTextColor","SetViewportExtEx","SetViewportOrgEx","SetWindowExtEx",
     "SetWindowOrgEx","SetWorldTransform","StretchBlt","StretchDIBits","TextOutA",
     "UnrealizeObject","UpdateColors" };

#define GDI32_FUNC_COUNT (sizeof(Gdi32Func)/sizeof(Gdi32Func[0]))


// some advapi32 functions

static char* Advapi32Func[] = {"RegCloseKey","RegConnectRegistryA","RegCreateKeyA",
     "RegCreateKeyExA","RegDeleteKeyA","RegDeleteValueA","RegEnumKeyA","RegEnumKeyExA",
     "RegEnumValueA","RegFlushKey","RegNotifyChangeKeyValue","RegOpenKeyA","RegOpenKeyExA",
     "RegQueryInfoKeyA","RegQueryValueA","RegQueryValueExA","RegSetValueA","RegSetValueExA"};

#define ADVAPI32_FUNC_COUNT (sizeof(Advapi32Func)/sizeof(Advapi32Func[0]))


// some ntdll functions

static char* NtdllFunc[] = {"DbgBreakPoint","DbgPrint","NtAddAtom","NtAllocateVirtualMemory",
     "NtClearEvent","NtClose","NtCreateEvent","NtCreateEventPair","NtCreateKey",
     "NtCreateMutant","NtCreateProcess","NtCreateSection","NtCreateSemaphore",
     "NtCreateThread","NtDelayExecution","NtDeleteKey","NtDeleteValueKey",
     "NtDisplayString","NtEnumerateKey","NtEnumerateValueKey","NtFindAtom","NtFlushKey",
     "NtFlushVirtualMemory","NtFreeVirtualMemory","NtGetTickCount","NtLoadKey",
     "NtLockVirtualMemory","NtMapViewOfSection","NtOpenEvent","NtOpenEventPair",
     "NtOpenKey","NtOpenMutant","NtOpenProcess","NtOpenSection","NtOpenSemaphore",
     "NtOpenThread","NtProtectVirtualMemory","NtPulseEvent","NtQueryEvent","NtQueryKey",
     "NtQueryMutant","NtQuerySection","NtQuerySemaphore","NtQuerySystemTime",
     "NtQueryValueKey","NtQueryVirtualMemory","NtReadVirtualMemory",
     "NtReleaseMutant","NtReleaseSemaphore","NtReplaceKey","NtResetEvent","NtRestoreKey",
     "NtResumeThread","NtSaveKey","NtSetEvent","NtSetTimer","NtSetValueKey","NtSuspendThread",
     "NtTerminateProcess","NtTerminateThread","NtUnloadKey","NtWaitForMultipleObjects",
     "NtWaitForSingleObject","NtWriteVirtualMemory","RtlAllocateAndInitializeSid",
     "RtlAllocateHandle","RtlAllocateHeap","RtlAnsiCharToUnicodeChar","RtlAnsiStringToUnicodeSize",
     "RtlAnsiStringToUnicodeString","RtlAppendAsciizToString","RtlAppendStringToString",
     "RtlAppendUnicodeStringToString","RtlAppendUnicodeToString","RtlAreBitsClear",
     "RtlAreBitsSet","RtlCharToInteger","RtlCheckRegistryKey","RtlClearAllBits",
     "RtlClearBits","RtlCompactHeap","RtlCompareMemory","RtlCompareMemoryUlong",
     "RtlCompareString","RtlCompareUnicodeString","RtlConvertLongToLargeInteger",
     "RtlConvertSidToUnicodeString","RtlConvertUlongToLargeInteger","RtlCopyLuid",
     "RtlCopyLuidAndAttributesArray","RtlCopySecurityDescriptor","RtlCopyString",
     "RtlCopyUnicodeString","RtlCreateAcl","RtlCreateHeap","RtlCreateRegistryKey",
     "RtlCreateSecurityDescriptor","RtlCreateUnicodeString","RtlCreateUnicodeStringFromAsciiz",
     "RtlCreateUserProcess","RtlCreateUserSecurityObject","RtlCreateUserThread",
     "RtlDeleteCriticalSection","RtlDeleteRegistryValue","RtlDeleteSecurityObject",
     "RtlDestroyHeap","RtlDowncaseUnicodeString","RtlEnlargedIntegerMultiply",
     "RtlEnterCriticalSection","RtlFillMemory","RtlFindClearBits","RtlFindSetBits",
     "RtlFormatMessage","RtlFreeAnsiString","RtlFreeHeap","RtlFreeOemString",
     "RtlFreeUnicodeString","RtlInitAnsiString","RtlInitString","RtlInitUnicodeString",
     "RtlInitializeCriticalSection","RtlLeaveCriticalSection","RtlLocalTimeToSystemTime",
     "RtlLockHeap","RtlMoveMemory","RtlProtectHeap","RtlQueryRegistryValues",
     "RtlQueryTimeZoneInformation","RtlReAllocateHeap","RtlSetAllBits","RtlSetBits",
     "RtlSizeHeap","RtlSystemTimeToLocalTime","RtlUnicodeStringToAnsiString",
     "RtlUnlockHeap","RtlUnwind","RtlWriteRegistryValue","RtlZeroHeap","RtlZeroMemory"};

IMPORTS Win32Imports[] = {
    { Kernel32Func, KERNEL32_FUNC_COUNT, "kernel32.dll" },
    { User32Func,   USER32_FUNC_COUNT,   "user32.dll" },
    { Gdi32Func,    GDI32_FUNC_COUNT,    "gdi32.dll" },
    { Advapi32Func, ADVAPI32_FUNC_COUNT, "advapi32.dll" }
  };

DWORD Win32ImportsCount = sizeof(Win32Imports)/sizeof(Win32Imports[0]);

IMPORTS NativeImports[] = {
    { NtdllFunc, NTDLL_FUNC_COUNT, "ntdll.dll" }
  };

DWORD NativeImports = sizeof(NativeImports)/sizeof(NativeImports[0]);


static BYTE StubA[] = { 0x4D, 0x5A, 0x78, 0x00, 0x01, 0x00, 0x00, 0x00,
                        0x04, 0x00, 0x21, 0x00, 0xFF, 0xFF, 0x04, 0x00,
                        0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
                        0x0E, 0x1F, 0xB4, 0x09, 0xBA, 0x0E, 0x00, 0xCD,
                        0x21, 0xB8, 0x01, 0x4C, 0xCD, 0x21, 0x54, 0x68,
                        0x69, 0x73, 0x20, 0x70, 0x72, 0x6F, 0x67, 0x72,
                        0x61, 0x6D, 0x20, 0x63, 0x61, 0x6E, 0x6E, 0x6F,
                        0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x75, 0x6E,
                        0x20, 0x69, 0x6E, 0x20, 0x44, 0x4F, 0x53, 0x20,
                        0x6D, 0x6F, 0x64, 0x65, 0x2E, 0x0D, 0x0A, 0x24 };

static BYTE StubB[] = { 0x4D, 0x5A, 0x90, 0x00, 0x03, 0x00, 0x00, 0x00,
                        0x04, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00,
                        0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
                        0x0E, 0x1F, 0xBA, 0x0E, 0x00, 0xB4, 0x09, 0xCD,
                        0x21, 0xB8, 0x01, 0x4C, 0xCD, 0x21, 0x54, 0x68,
                        0x69, 0x73, 0x20, 0x70, 0x72, 0x6F, 0x67, 0x72,
                        0x61, 0x6D, 0x20, 0x63, 0x61, 0x6E, 0x6E, 0x6F,
                        0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x75, 0x6E,
                        0x20, 0x69, 0x6E, 0x20, 0x44, 0x4F, 0x53, 0x20,
                        0x6D, 0x6F, 0x64, 0x65, 0x2E, 0x0D, 0x0D, 0x0A,
                        0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static BYTE StubC[] = { 0x4D, 0x5A, 0x80, 0x01, 0xD2, 0x01, 0x00, 0x00,
                        0x04, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00,
                        0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
                        0x0E, 0x1F, 0xBA, 0x0E, 0x00, 0xB4, 0x09, 0xCD,
                        0x21, 0xB8, 0x01, 0x4C, 0xCD, 0x21, 0x54, 0x68,
                        0x69, 0x73, 0x20, 0x70, 0x72, 0x6F, 0x67, 0x72,
                        0x61, 0x6D, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69,
                        0x72, 0x65, 0x73, 0x20, 0x4D, 0x69, 0x63, 0x72,
                        0x6F, 0x73, 0x6F, 0x66, 0x74, 0x20, 0x57, 0x69,
                        0x6E, 0x64, 0x6F, 0x77, 0x73, 0x2E, 0x0D, 0x0A,
                        0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static BYTE StubD[] = { 0x4D, 0x5A, 0x50, 0x00, 0x02, 0x00, 0x00, 0x00,
                        0x04, 0x00, 0x0F, 0x00, 0xFF, 0xFF, 0x00, 0x00,
                        0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x40, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
                        0xBA, 0x10, 0x00, 0x0E, 0x1F, 0xB4, 0x09, 0xCD,
                        0x21, 0xB8, 0x01, 0x4C, 0xCD, 0x21, 0x90, 0x90,
                        0x54, 0x68, 0x69, 0x73, 0x20, 0x70, 0x72, 0x6F,
                        0x67, 0x72, 0x61, 0x6D, 0x20, 0x6D, 0x75, 0x73,
                        0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x75, 0x6E,
                        0x20, 0x75, 0x6E, 0x64, 0x65, 0x72, 0x20, 0x57,
                        0x69, 0x6E, 0x33, 0x32, 0x0D, 0x0A, 0x24, 0x37,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

#define STUBASZ (sizeof(StubA)/sizeof(StubA[0]))
#define STUBBSZ (sizeof(StubB)/sizeof(StubB[0]))
#define STUBCSZ (sizeof(StubC)/sizeof(StubC[0]))
#define STUBDSZ (sizeof(StubD)/sizeof(StubD[0]))

BYTE* Stubs[] = { StubA, StubB, StubC, StubD };
DWORD StubSz[] = { STUBASZ, STUBBSZ, STUBCSZ, STUBDSZ };
DWORD StubsCount = sizeof(Stubs)/sizeof(Stubs[0]);
